using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using System.Diagnostics;
using System.Drawing.Printing;

namespace BarCodeClient
{
	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class frmMain: System.Windows.Forms.Form
	{
		private System.Windows.Forms.Button btGenerate;
		private System.Windows.Forms.GroupBox groupBox1;
		private System.Windows.Forms.Label label2;
		private System.Windows.Forms.Label label1;
		private System.Windows.Forms.Label label3;
		private System.Windows.Forms.GroupBox groupBox2;
		private System.Windows.Forms.PictureBox pictBox;
		private System.Windows.Forms.StatusBarPanel statusBarPanel1;
		private System.Windows.Forms.StatusBar statbar;
		private System.Windows.Forms.ComboBox comboBox1;
		private System.Windows.Forms.TextBox ResolutionDPI;
		private System.Windows.Forms.TextBox TextToEncode;
		private System.Windows.Forms.Button SaveBarcode;
		private System.Windows.Forms.Button PrintBarcode;
		private System.Windows.Forms.Button CopyToClipboard;
		private System.Drawing.Printing.PrintDocument printDocument1;
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public frmMain()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btGenerate = new System.Windows.Forms.Button();
			this.groupBox1 = new System.Windows.Forms.GroupBox();
			this.label3 = new System.Windows.Forms.Label();
			this.ResolutionDPI = new System.Windows.Forms.TextBox();
			this.TextToEncode = new System.Windows.Forms.TextBox();
			this.label2 = new System.Windows.Forms.Label();
			this.label1 = new System.Windows.Forms.Label();
			this.groupBox2 = new System.Windows.Forms.GroupBox();
			this.pictBox = new System.Windows.Forms.PictureBox();
			this.statbar = new System.Windows.Forms.StatusBar();
			this.statusBarPanel1 = new System.Windows.Forms.StatusBarPanel();
			this.comboBox1 = new System.Windows.Forms.ComboBox();
			this.SaveBarcode = new System.Windows.Forms.Button();
			this.PrintBarcode = new System.Windows.Forms.Button();
			this.CopyToClipboard = new System.Windows.Forms.Button();
			this.printDocument1 = new System.Drawing.Printing.PrintDocument();
			this.groupBox1.SuspendLayout();
			this.groupBox2.SuspendLayout();
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).BeginInit();
			this.SuspendLayout();
			// 
			// btGenerate
			// 
			this.btGenerate.Location = new System.Drawing.Point(464, 16);
			this.btGenerate.Name = "btGenerate";
			this.btGenerate.Size = new System.Drawing.Size(112, 24);
			this.btGenerate.TabIndex = 2;
			this.btGenerate.Text = "Generate Barcode";
			this.btGenerate.Click += new System.EventHandler(this.btGenerate_Click);
			// 
			// groupBox1
			// 
			this.groupBox1.Controls.Add(this.comboBox1);
			this.groupBox1.Controls.Add(this.label3);
			this.groupBox1.Controls.Add(this.ResolutionDPI);
			this.groupBox1.Controls.Add(this.TextToEncode);
			this.groupBox1.Controls.Add(this.label2);
			this.groupBox1.Controls.Add(this.label1);
			this.groupBox1.Location = new System.Drawing.Point(8, 8);
			this.groupBox1.Name = "groupBox1";
			this.groupBox1.Size = new System.Drawing.Size(448, 120);
			this.groupBox1.TabIndex = 9;
			this.groupBox1.TabStop = false;
			this.groupBox1.Text = "Barcode Parameters";
			// 
			// label3
			// 
			this.label3.Location = new System.Drawing.Point(16, 96);
			this.label3.Name = "label3";
			this.label3.Size = new System.Drawing.Size(80, 16);
			this.label3.TabIndex = 14;
			this.label3.Text = "ResolutionDPI";
			this.label3.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// ResolutionDPI
			// 
			this.ResolutionDPI.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.ResolutionDPI.Location = new System.Drawing.Point(112, 96);
			this.ResolutionDPI.Name = "ResolutionDPI";
			this.ResolutionDPI.Size = new System.Drawing.Size(120, 20);
			this.ResolutionDPI.TabIndex = 13;
			this.ResolutionDPI.Text = "96";
			// 
			// TextToEncode
			// 
			this.TextToEncode.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.TextToEncode.Location = new System.Drawing.Point(112, 24);
			this.TextToEncode.Name = "TextToEncode";
			this.TextToEncode.Size = new System.Drawing.Size(232, 20);
			this.TextToEncode.TabIndex = 12;
			this.TextToEncode.Text = "1234567890";
			// 
			// label2
			// 
			this.label2.Location = new System.Drawing.Point(8, 24);
			this.label2.Name = "label2";
			this.label2.Size = new System.Drawing.Size(88, 16);
			this.label2.TabIndex = 11;
			this.label2.Text = "TextToEncode";
			this.label2.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// label1
			// 
			this.label1.Location = new System.Drawing.Point(16, 56);
			this.label1.Name = "label1";
			this.label1.Size = new System.Drawing.Size(72, 16);
			this.label1.TabIndex = 10;
			this.label1.Text = "SymbologyID";
			this.label1.TextAlign = System.Drawing.ContentAlignment.MiddleRight;
			// 
			// groupBox2
			// 
			this.groupBox2.Controls.Add(this.pictBox);
			this.groupBox2.Location = new System.Drawing.Point(8, 136);
			this.groupBox2.Name = "groupBox2";
			this.groupBox2.Size = new System.Drawing.Size(568, 216);
			this.groupBox2.TabIndex = 10;
			this.groupBox2.TabStop = false;
			this.groupBox2.Text = "Result Barcode Image";
			// 
			// pictBox
			// 
			this.pictBox.Location = new System.Drawing.Point(8, 24);
			this.pictBox.Name = "pictBox";
			this.pictBox.Size = new System.Drawing.Size(536, 168);
			this.pictBox.SizeMode = System.Windows.Forms.PictureBoxSizeMode.CenterImage;
			this.pictBox.TabIndex = 1;
			this.pictBox.TabStop = false;
			// 
			// statbar
			// 
			this.statbar.Location = new System.Drawing.Point(0, 367);
			this.statbar.Name = "statbar";
			this.statbar.Panels.AddRange(new System.Windows.Forms.StatusBarPanel[] {
																					   this.statusBarPanel1});
			this.statbar.Size = new System.Drawing.Size(584, 22);
			this.statbar.TabIndex = 11;
			// 
			// statusBarPanel1
			// 
			this.statusBarPanel1.AutoSize = System.Windows.Forms.StatusBarPanelAutoSize.Spring;
			this.statusBarPanel1.Text = "statusBarPanel1";
			// 
			// comboBox1
			// 
			this.comboBox1.Items.AddRange(new object[] {
														   "Code 39",
														   "Code 39 FULL ASCII",
														   "Code 93",
														   "UPC-A",
														   "EAN 13",
														   "EAN 8",
														   "UPC-E",
														   "BOOKLAND",
														   "CODE 128",
														   "UCC/EAN 128",
														   "INDUSTRIAL 2 OF 5",
														   "INTERLEAVED 2 OF 5",
														   "CODE  11\t\t",
														   "CODABAR",
														   "MSI-PLESSEY",
														   "PDF417",
														   "DataMatrix"});
			this.comboBox1.Location = new System.Drawing.Point(112, 56);
			this.comboBox1.Name = "comboBox1";
			this.comboBox1.Size = new System.Drawing.Size(121, 21);
			this.comboBox1.TabIndex = 15;
			this.comboBox1.Text = "Code 39";
			// 
			// SaveBarcode
			// 
			this.SaveBarcode.Location = new System.Drawing.Point(464, 40);
			this.SaveBarcode.Name = "SaveBarcode";
			this.SaveBarcode.Size = new System.Drawing.Size(112, 24);
			this.SaveBarcode.TabIndex = 12;
			this.SaveBarcode.Text = "Save Barcode";
			this.SaveBarcode.Click += new System.EventHandler(this.button1_Click);
			// 
			// PrintBarcode
			// 
			this.PrintBarcode.Location = new System.Drawing.Point(464, 64);
			this.PrintBarcode.Name = "PrintBarcode";
			this.PrintBarcode.Size = new System.Drawing.Size(112, 24);
			this.PrintBarcode.TabIndex = 13;
			this.PrintBarcode.Text = "Print Barcode";
			this.PrintBarcode.Click += new System.EventHandler(this.PrintBarcode_Click);
			// 
			// CopyToClipboard
			// 
			this.CopyToClipboard.Location = new System.Drawing.Point(464, 88);
			this.CopyToClipboard.Name = "CopyToClipboard";
			this.CopyToClipboard.Size = new System.Drawing.Size(112, 24);
			this.CopyToClipboard.TabIndex = 14;
			this.CopyToClipboard.Text = "CopyToClipboard";
			this.CopyToClipboard.Click += new System.EventHandler(this.CopyToClipboard_Click);
			// 
			// frmMain
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(584, 389);
			this.Controls.Add(this.CopyToClipboard);
			this.Controls.Add(this.PrintBarcode);
			this.Controls.Add(this.SaveBarcode);
			this.Controls.Add(this.statbar);
			this.Controls.Add(this.groupBox2);
			this.Controls.Add(this.btGenerate);
			this.Controls.Add(this.groupBox1);
			this.Name = "frmMain";
			this.Text = "Web Service Barcode Generator client";
			this.groupBox1.ResumeLayout(false);
			this.groupBox2.ResumeLayout(false);
			((System.ComponentModel.ISupportInitialize)(this.statusBarPanel1)).EndInit();
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new frmMain());
		}

		private void btGenerate_Click(object sender, System.EventArgs e)
		{
		
			
			pictBox.Image=GetBitmap(96);

			
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
		 Bitmap bmp= GetBitmap(300);
		 bmp.Save(@"c:\test.jpg",System.Drawing.Imaging.ImageFormat.Jpeg);
		}
        
		private Bitmap GetBitmap(int resolution)
		{
			this.Cursor=Cursors.WaitCursor;
			statbar.Panels[0].Text="Generating barcode...";

			com.easebarcode.www.ImageService barcodeservice =new BarCodeClient.com.easebarcode.www.ImageService() ;
			BarCodeClient.com.easebarcode.www.Symbology symbology;
			switch( comboBox1.SelectedIndex)
			{
				case 0: symbology= com.easebarcode.www.Symbology.Code39;break;
				case 1: symbology= com.easebarcode.www.Symbology.Code39ASCII;break;
				case 2: symbology= com.easebarcode.www.Symbology.Code93;break;
				case 3: symbology= com.easebarcode.www.Symbology.UPCA;break;
				case 4: symbology= com.easebarcode.www.Symbology.EAN13;break;
				case 5: symbology= com.easebarcode.www.Symbology.EAN8;break;
				case 6: symbology= com.easebarcode.www.Symbology.UPCE;break;
				case 7: symbology= com.easebarcode.www.Symbology.BookLand;break;
				case 8: symbology= com.easebarcode.www.Symbology.Code128;break;
				case 9: symbology= com.easebarcode.www.Symbology.UCC128;break;
				case 10: symbology=com.easebarcode.www.Symbology.Code25;break;
				case 11: symbology=com.easebarcode.www.Symbology.I25;break;
				case 12: symbology=com.easebarcode.www.Symbology.Code11;break;
				case 13: symbology=com.easebarcode.www.Symbology.Codabar;break;
				case 14: symbology=com.easebarcode.www.Symbology.MSI;break;
				case 15: symbology=com.easebarcode.www.Symbology.PDF417;break;
				case 16: symbology=com.easebarcode.www.Symbology.DataMatix;break;
				default: symbology=com.easebarcode.www.Symbology.Code39;break;
			}

			System.Byte[] imgBarcode= barcodeservice.BarcodeImage(symbology,TextToEncode.Text.Trim(),Convert.ToInt32(ResolutionDPI.Text));
			//Set resolution as 96 DPI for displaying, set as 300 for printing
			MemoryStream memStream = new MemoryStream(imgBarcode); 			
			Bitmap bmp =new Bitmap(memStream);
			statbar.Panels[0].Text="Done.";
			this.Cursor=Cursors.Default;
			return bmp;
			bmp.Dispose();
		}

		private void PrintBarcode_Click(object sender, System.EventArgs e)
		{
			try
			{
				printDocument1.PrintPage +=  new System.Drawing.Printing.PrintPageEventHandler(this.PrintPageEventHandler);
				printDocument1.DocumentName = " EaseSoft Barcode Print Test";
				printDocument1.Print();
		
			}
			catch( Exception ex)
			{
				MessageBox.Show( ex.Message);
			}
		}
			
       
		private void PrintPageEventHandler(Object obj,PrintPageEventArgs ev)
		{
			Bitmap bmp= GetBitmap(300);
			Graphics g = ev.Graphics;
			g.DrawImage(bmp,40,100);
			bmp.Dispose();
		}

		private void CopyToClipboard_Click(object sender, System.EventArgs e)
		{
		  Bitmap bmp= GetBitmap(96);
		  System.Windows.Forms.DataObject dataobj = new DataObject();
		  dataobj.SetData(System.Windows.Forms.DataFormats.Bitmap,true,bmp);
		  Clipboard.SetDataObject(dataobj,true);
		  bmp.Dispose();
		}
     

	}
}
